//*********************************************************************
//
//    FAT32 MMC/SD   1.10.
// 
// 1.  makefile.mak  .  
//    Project ->Configuration options. 
//      General   Use external makefile. 
//     ""  makefile.mak.
//
// 2.  makefile.mak    : 
//    MCU -  
//    F_CPU -   
//    BOOTLDRSIZE -   
//    BOOTLOADERSTARTADR -   
//    TARGET -  *.hex ,   
//    OBJDIR - ,     
//
// 3.  SD_routines.h  ,      - 
// 	    SD_CS_ASSERT  SD_CS_DEASSERT.  ,  
//     SD  (SPI_DI, SPI_DO, SPI_Clock) 
//       SPI.   PORTX  DDRX  
//	   main.
//
// 4.  megavar.h,    , 
//     EEPROM  FLASH     : 
//    EE_SECTOR_FOR_READ  FL_SECTOR_FOR_READ  EEPROM  FLASH 
//    . 
// 
// 5.  main.   int main(void)    
//    bootloader-a (    PINC).    
//        "boot" (  loadboot()).
// 
// 6. SD       FAT32. 
//	    512 .
//        bin- EEPROM  FLASH. 
//     "boot.ee"  "boot.fl"   EEPROM - "ee", 
//     FLASH - "fl".  EEPROM  . 
//     FLASH   .   -  
//      EE_SECTOR_FOR_READ*512  FL_SECTOR_FOR_READ*512 
//     EEPROM  FLASH .
// 
// 7.     
//    progeeprom32.bat ( )  
//    progHfuse32.bat ( ). 
//       usbasp 
//      .
//
// 8.       matrex@rambler.ru.
// 
// 9.      :
//    http://www.mikrocontroller.net/articles/MMC/SD_Bootloader_f%C3%BCr_AT_Mega
//    http://www.ulrichradig.de/home/index.php/avr/mmc-sd
//    http://www.dharmanitech.com/2009/01/sd-card-interfacing-with-atmega8-fat32.html
//
//
//     :
//
//    01.10.2011 v. 1.01.
//        EEPROM   ATMEGA32. 
//           
//    .    EEPROM .
//
//    08.12.2011 v. 1.10.
//       :
//		-      ( )
//		    "boot.fl" "boot.ee"
//		-     "upload.bat"   
//		  ,    upload,   - 
//		      " ", 
//		  zagrus(#0D)(#0A)
//
//    01.05.2012 v. 1.20.
//        ATmega64
//		-      ( )
//
//*********************************************************************



#include <util/delay.h>

#include <avr/boot.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>

#include "FAT32.h"
#include "SPI_routines.h"
#include "SD_routines.h"


#define FL_SECTOR_FOR_READ 120	//  FLASH     .
			   		          	//  BOOTLOADERSTARTADR/512 ( makefile.mak)
#define EE_SECTOR_FOR_READ 4  	//  EEPROM     .
			   		          	//  1024/512 (1024 -  FLASH  )
#define cPathSIze 32 			//     
#define STOPPOINT(x) eeprom_write_byte(0,x) //  ,   
void (*app_start)(void) = 0x0000;



void upload(char *fileName, unsigned char memtype)
{
	struct dir_Structure *dir;
	unsigned long cluster, byteCounter = 0, fileSize, firstSector;
	unsigned char filesector, error, p;
	uint16_t  i, j, adr, *lpword;
	error = convertFileName (fileName); //convert fileName into FAT format
	if(error) return;
	dir = findFiles (fileName); //get the file location
	if(dir == 0) return;
	cluster = (((unsigned long) dir->firstClusterHI) << 16) | dir->firstClusterLO;
	fileSize = dir->fileSize;
	firstSector = getFirstSector (cluster);
		switch (memtype) //    
		{
		case 0:
			//  FLASH
			for(filesector=0; filesector < FL_SECTOR_FOR_READ; filesector++)
			{
   			SD_readSingleBlock(firstSector + filesector);
			lpword = (uint16_t*) buffer;
				for (i=0; i<(512 / SPM_PAGESIZE); i++)
				{
					adr = (filesector * 512) + i * SPM_PAGESIZE;
					boot_page_erase(adr);
					while (boot_rww_busy()) boot_rww_enable();
					for (j=0; j<SPM_PAGESIZE; j+=2) boot_page_fill(adr + j, *lpword++);
					boot_page_write(adr);
					while (boot_rww_busy())	boot_rww_enable();
				};
		  	cluster = getSetNextCluster (cluster, GET, 0);
			}; 
	 	break;
		default:
			//  EEPROM
			adr=0;
			for (filesector = 0; filesector < EE_SECTOR_FOR_READ; filesector++)
			{
   				SD_readSingleBlock(firstSector + filesector);
				for(j=0;j<512;j++)
				{
					eeprom_busy_wait();
					eeprom_write_byte(adr, buffer[j]);
					adr++;
				}
		  	cluster = getSetNextCluster (cluster, GET, 0);
			};
	    break;
		}		
}





unsigned char uploadfilename(char *fileName, char *load)
{
	struct dir_Structure *dir;
	unsigned long cluster, byteCounter = 0, fileSize, firstSector;
	unsigned char  error, p;
	uint16_t  i, j, adr, *lpword;
	error = convertFileName (fileName); //convert fileName into FAT format
	if(error) return;
	dir = findFiles (fileName); //get the file location
	if(dir == 0) return;
	cluster = (((unsigned long) dir->firstClusterHI) << 16) | dir->firstClusterLO;
	fileSize = dir->fileSize;
	firstSector = getFirstSector (cluster);
   	SD_readSingleBlock(firstSector);
	for(j=0;j<cPathSIze;j++)
		{
		if (buffer[j]<33) return 0;
		load[j]=buffer[j];
	//	eeprom_write_byte(j+1, buffer[j]);
		}
	return 0;
}





void loadboot()
{

	char f[]="boot.fl";     //   FLASH
	char f1[]="boot.ee";     //   EEPROM

/*    .  64    
	char filename[]="boot";     //  ,     
	char f[cPathSIze];
	char f1[cPathSIze];
	char ee=".ee";
	char fl=".fl";
	memset(f,0,sizeof(f));
	memset(f1,0,sizeof(f1));
	memcpy(f,filename,strlen(filename));
	strcat(f,fl);
	memcpy(f1,filename,strlen(filename));
	strcat(f1,ee);
*/

	upload(f,0); 				//  FLASH
	upload(f1,1); 				//  EEPROM

}


void loadfile()
{
	char fn[]="upload.bat";     	//  ,     
	char filename[cPathSIze];				//   
	char f[cPathSIze];
	char f1[cPathSIze];
	char ee=".ee";
	char fl=".fl";
	memset(filename,0,sizeof(filename));					
	if (uploadfilename(fn,filename)!=0) return; //   
//	for(unsigned char u=0;u<sizeof(filename);u++) {eeprom_write_byte(u+32, filename[u]);}
	memset(f,0,sizeof(f));
	memset(f1,0,sizeof(f1));
	memcpy(f,filename,strlen(filename));
	strcat(f,fl);
	memcpy(f1,filename,strlen(filename));
	strcat(f1,ee);
	upload(f,0); 				//  FLASH
	upload(f1,1); 				//  EEPROM
}


int main(void)
{

	unsigned char error;
	unsigned char i;
	//  ,  
	cli();
	wdt_reset();
	wdt_disable();

	//   
 	PORTC = 0xFF; 	//pullup for keys
 	DDRC  = 0x00;	// x x x START ROTATE LEFT RIGHT DOWN

	//  
	PORTB = 0xFF;
	DDRB  = 0xF7; //MISO  ,   

	//  SPI init
	SPCR = (1<<MSTR)|(1<<SPE); // SPI config
	SPSR = (1<<SPI2X); // double speed


	SPI_transmit(0x55);

	//   .    PF
 	// PORTF = 0xFF;DDRF  = 0xFF; while (1) {PORTF=0; _delay_ms(300); PORTF=255; _delay_ms(300);}


	//   
	cardType = 0;
	for (i=0; i<10; i++) {error = SD_init();if(!error) break;}
	if(error) app_start(); //  -  
	_delay_ms(10);   //some delay
	error = getBootSectorData (); //read boot sector and keep necessary data in global variables
	if(error) app_start(); //  -  


	if(PINC!=255) 				//   bootloader- (  VK1)
    {
		loadboot();
	}
	else
	{
		loadfile();				//    
	}
	app_start();				//  

}


























